@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Configuration for a scoring code asset.
 * @property codeId ARM resource ID of the code asset.
 * @property scoringScript [Required] The script to execute on startup. eg. "score.py"
 */
public data class CodeConfigurationResponse(
    public val codeId: String? = null,
    public val scoringScript: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.CodeConfigurationResponse): CodeConfigurationResponse = CodeConfigurationResponse(
            codeId = javaType.codeId().map({ args0 -> args0 }).orElse(null),
            scoringScript = javaType.scoringScript(),
        )
    }
}
