@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Code asset version details.
 * @property codeUri Uri where code is located
 * @property description The asset description text.
 * @property isAnonymous If the name version are system generated (anonymous registration).
 * @property isArchived Is the asset archived?
 * @property properties The asset property dictionary.
 * @property provisioningState Provisioning state for the code version.
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 */
public data class CodeVersionResponse(
    public val codeUri: String? = null,
    public val description: String? = null,
    public val isAnonymous: Boolean? = null,
    public val isArchived: Boolean? = null,
    public val properties: Map<String, String>? = null,
    public val provisioningState: String,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.CodeVersionResponse): CodeVersionResponse = CodeVersionResponse(
            codeUri = javaType.codeUri().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            isAnonymous = javaType.isAnonymous().map({ args0 -> args0 }).orElse(null),
            isArchived = javaType.isArchived().map({ args0 -> args0 }).orElse(null),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            provisioningState = javaType.provisioningState(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
