@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Command job definition.
 * @property codeId ARM resource ID of the code asset.
 * @property command [Required] The command to execute on startup of the job. eg. "python train.py"
 * @property componentId ARM resource ID of the component resource.
 * @property computeId ARM resource ID of the compute resource.
 * @property description The asset description text.
 * @property displayName Display name of job.
 * @property distribution Distribution configuration of the job. If set, this should be one of Mpi, Tensorflow, PyTorch, or null.
 * @property environmentId [Required] The ARM resource ID of the Environment specification for the job.
 * @property environmentVariables Environment variables included in the job.
 * @property experimentName The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
 * @property identity Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
 * Defaults to AmlToken if null.
 * @property inputs Mapping of input data bindings used in the job.
 * @property isArchived Is the asset archived?
 * @property jobType Enum to determine the type of job.
 * Expected value is 'Command'.
 * @property limits Command Job limit.
 * @property outputs Mapping of output data bindings used in the job.
 * @property parameters Input parameters.
 * @property properties The asset property dictionary.
 * @property resources Compute Resource configuration for the job.
 * @property services List of JobEndpoints.
 * For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
 * @property status Status of the job.
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 */
public data class CommandJobResponse(
    public val codeId: String? = null,
    public val command: String,
    public val componentId: String? = null,
    public val computeId: String? = null,
    public val description: String? = null,
    public val displayName: String? = null,
    public val distribution: Any? = null,
    public val environmentId: String,
    public val environmentVariables: Map<String, String>? = null,
    public val experimentName: String? = null,
    public val identity: Any? = null,
    public val inputs: Map<String, Any>? = null,
    public val isArchived: Boolean? = null,
    public val jobType: String,
    public val limits: CommandJobLimitsResponse? = null,
    public val outputs: Map<String, Any>? = null,
    public val parameters: Any,
    public val properties: Map<String, String>? = null,
    public val resources: JobResourceConfigurationResponse? = null,
    public val services: Map<String, JobServiceResponse>? = null,
    public val status: String,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.CommandJobResponse): CommandJobResponse = CommandJobResponse(
            codeId = javaType.codeId().map({ args0 -> args0 }).orElse(null),
            command = javaType.command(),
            componentId = javaType.componentId().map({ args0 -> args0 }).orElse(null),
            computeId = javaType.computeId().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            distribution = javaType.distribution().map({ args0 -> args0 }).orElse(null),
            environmentId = javaType.environmentId(),
            environmentVariables = javaType.environmentVariables().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            experimentName = javaType.experimentName().map({ args0 -> args0 }).orElse(null),
            identity = javaType.identity().map({ args0 -> args0 }).orElse(null),
            inputs = javaType.inputs().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            isArchived = javaType.isArchived().map({ args0 -> args0 }).orElse(null),
            jobType = javaType.jobType(),
            limits = javaType.limits().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.CommandJobLimitsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            outputs = javaType.outputs().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            parameters = javaType.parameters(),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            resources = javaType.resources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.JobResourceConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            services = javaType.services().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.machinelearningservices.kotlin.outputs.JobServiceResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
