@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Component container definition.
 * <see href="https://docs.microsoft.com/en-us/azure/machine-learning/reference-yaml-component-command" />
 * @property description The asset description text.
 * @property isArchived Is the asset archived?
 * @property latestVersion The latest version inside this container.
 * @property nextVersion The next auto incremental version
 * @property properties The asset property dictionary.
 * @property provisioningState Provisioning state for the component container.
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 */
public data class ComponentContainerResponse(
    public val description: String? = null,
    public val isArchived: Boolean? = null,
    public val latestVersion: String,
    public val nextVersion: String,
    public val properties: Map<String, String>? = null,
    public val provisioningState: String,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ComponentContainerResponse): ComponentContainerResponse = ComponentContainerResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            isArchived = javaType.isArchived().map({ args0 -> args0 }).orElse(null),
            latestVersion = javaType.latestVersion(),
            nextVersion = javaType.nextVersion(),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            provisioningState = javaType.provisioningState(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
