@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Definition of a component version: defines resources that span component types.
 * @property componentSpec Defines Component definition details.
 * <see href="https://docs.microsoft.com/en-us/azure/machine-learning/reference-yaml-component-command" />
 * @property description The asset description text.
 * @property isAnonymous If the name version are system generated (anonymous registration).
 * @property isArchived Is the asset archived?
 * @property properties The asset property dictionary.
 * @property provisioningState Provisioning state for the component version.
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 */
public data class ComponentVersionResponse(
    public val componentSpec: Any? = null,
    public val description: String? = null,
    public val isAnonymous: Boolean? = null,
    public val isArchived: Boolean? = null,
    public val properties: Map<String, String>? = null,
    public val provisioningState: String,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ComponentVersionResponse): ComponentVersionResponse = ComponentVersionResponse(
            componentSpec = javaType.componentSpec().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            isAnonymous = javaType.isAnonymous().map({ args0 -> args0 }).orElse(null),
            isArchived = javaType.isArchived().map({ args0 -> args0 }).orElse(null),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            provisioningState = javaType.provisioningState(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
