@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines an Aml Instance application and its connectivity endpoint URI.
 * @property displayName Name of the ComputeInstance application.
 * @property endpointUri Application' endpoint URI.
 */
public data class ComputeInstanceApplicationResponse(
    public val displayName: String? = null,
    public val endpointUri: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ComputeInstanceApplicationResponse): ComputeInstanceApplicationResponse = ComputeInstanceApplicationResponse(
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            endpointUri = javaType.endpointUri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
