@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines all connectivity endpoints and properties for an ComputeInstance.
 * @property privateIpAddress Private IP Address of this ComputeInstance (local to the VNET in which the compute instance is deployed).
 * @property publicIpAddress Public IP Address of this ComputeInstance.
 */
public data class ComputeInstanceConnectivityEndpointsResponse(
    public val privateIpAddress: String,
    public val publicIpAddress: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ComputeInstanceConnectivityEndpointsResponse): ComputeInstanceConnectivityEndpointsResponse = ComputeInstanceConnectivityEndpointsResponse(
            privateIpAddress = javaType.privateIpAddress(),
            publicIpAddress = javaType.publicIpAddress(),
        )
    }
}
