@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Defines an Aml Instance DataDisk.
 * @property caching Caching type of Data Disk.
 * @property diskSizeGB The initial disk size in gigabytes.
 * @property lun The lun is used to uniquely identify each data disk. If attaching multiple disks, each should have a distinct lun.
 * @property storageAccountType type of this storage account.
 */
public data class ComputeInstanceDataDiskResponse(
    public val caching: String? = null,
    public val diskSizeGB: Int? = null,
    public val lun: Int? = null,
    public val storageAccountType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ComputeInstanceDataDiskResponse): ComputeInstanceDataDiskResponse = ComputeInstanceDataDiskResponse(
            caching = javaType.caching().map({ args0 -> args0 }).orElse(null),
            diskSizeGB = javaType.diskSizeGB().map({ args0 -> args0 }).orElse(null),
            lun = javaType.lun().map({ args0 -> args0 }).orElse(null),
            storageAccountType = javaType.storageAccountType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
