@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The last operation on ComputeInstance.
 * @property operationName Name of the last operation.
 * @property operationStatus Operation status.
 * @property operationTime Time of the last operation.
 * @property operationTrigger Trigger of operation.
 */
public data class ComputeInstanceLastOperationResponse(
    public val operationName: String? = null,
    public val operationStatus: String? = null,
    public val operationTime: String? = null,
    public val operationTrigger: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ComputeInstanceLastOperationResponse): ComputeInstanceLastOperationResponse = ComputeInstanceLastOperationResponse(
            operationName = javaType.operationName().map({ args0 -> args0 }).orElse(null),
            operationStatus = javaType.operationStatus().map({ args0 -> args0 }).orElse(null),
            operationTime = javaType.operationTime().map({ args0 -> args0 }).orElse(null),
            operationTrigger = javaType.operationTrigger().map({ args0 -> args0 }).orElse(null),
        )
    }
}
