@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Specifies policy and settings for SSH access.
 * @property adminPublicKey Specifies the SSH rsa public key file as a string. Use "ssh-keygen -t rsa -b 2048" to generate your SSH key pairs.
 * @property adminUserName Describes the admin user name.
 * @property sshPort Describes the port for connecting through SSH.
 * @property sshPublicAccess State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on this instance. Enabled - Indicates that the public ssh port is open and accessible according to the VNet/subnet policy if applicable.
 */
public data class ComputeInstanceSshSettingsResponse(
    public val adminPublicKey: String? = null,
    public val adminUserName: String,
    public val sshPort: Int,
    public val sshPublicAccess: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ComputeInstanceSshSettingsResponse): ComputeInstanceSshSettingsResponse = ComputeInstanceSshSettingsResponse(
            adminPublicKey = javaType.adminPublicKey().map({ args0 -> args0 }).orElse(null),
            adminUserName = javaType.adminUserName(),
            sshPort = javaType.sshPort(),
            sshPublicAccess = javaType.sshPublicAccess().map({ args0 -> args0 }).orElse(null),
        )
    }
}
