@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Compute start stop schedule properties
 * @property action [Required] The compute power action.
 * @property cron Required if triggerType is Cron.
 * @property id A system assigned id for the schedule.
 * @property provisioningStatus The current deployment state of schedule.
 * @property recurrence Required if triggerType is Recurrence.
 * @property schedule [Deprecated] Not used any more.
 * @property status Is the schedule enabled or disabled?
 * @property triggerType [Required] The schedule trigger type.
 */
public data class ComputeStartStopScheduleResponse(
    public val action: String? = null,
    public val cron: CronResponse? = null,
    public val id: String,
    public val provisioningStatus: String,
    public val recurrence: RecurrenceResponse? = null,
    public val schedule: ScheduleBaseResponse? = null,
    public val status: String? = null,
    public val triggerType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ComputeStartStopScheduleResponse): ComputeStartStopScheduleResponse = ComputeStartStopScheduleResponse(
            action = javaType.action().map({ args0 -> args0 }).orElse(null),
            cron = javaType.cron().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.CronResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            provisioningStatus = javaType.provisioningStatus(),
            recurrence = javaType.recurrence().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.RecurrenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            schedule = javaType.schedule().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ScheduleBaseResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            triggerType = javaType.triggerType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
