@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cpu Number of vCPUs request/limit for container. More info:
 * https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
 * @property gpu Number of Nvidia GPU cards request/limit for container. More info:
 * https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
 * @property memory Memory size request/limit for container. More info:
 * https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
 */
public data class ContainerResourceSettingsResponse(
    public val cpu: String? = null,
    public val gpu: String? = null,
    public val memory: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ContainerResourceSettingsResponse): ContainerResourceSettingsResponse = ContainerResourceSettingsResponse(
            cpu = javaType.cpu().map({ args0 -> args0 }).orElse(null),
            gpu = javaType.gpu().map({ args0 -> args0 }).orElse(null),
            memory = javaType.memory().map({ args0 -> args0 }).orElse(null),
        )
    }
}
