@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The workflow trigger cron for ComputeStartStop schedule type.
 * @property expression [Required] Specifies cron expression of schedule.
 * The expression should follow NCronTab format.
 * @property startTime The start time in yyyy-MM-ddTHH:mm:ss format.
 * @property timeZone Specifies time zone in which the schedule runs.
 * TimeZone should follow Windows time zone format. Refer: https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11
 */
public data class CronResponse(
    public val expression: String? = null,
    public val startTime: String? = null,
    public val timeZone: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.CronResponse): CronResponse = CronResponse(
            expression = javaType.expression().map({ args0 -> args0 }).orElse(null),
            startTime = javaType.startTime().map({ args0 -> args0 }).orElse(null),
            timeZone = javaType.timeZone().map({ args0 -> args0 }).orElse(null),
        )
    }
}
