@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Specifies the custom service configuration
 * @property docker Describes the docker settings for the image
 * @property endpoints Configuring the endpoints for the container
 * @property environmentVariables Environment Variable for the container
 * @property image Describes the Image Specifications
 * @property name Name of the Custom Service
 * @property volumes Configuring the volumes for the container
 */
public data class CustomServiceResponse(
    public val docker: DockerResponse? = null,
    public val endpoints: List<EndpointResponse>? = null,
    public val environmentVariables: Map<String, EnvironmentVariableResponse>? = null,
    public val image: ImageResponse? = null,
    public val name: String? = null,
    public val volumes: List<VolumeDefinitionResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.CustomServiceResponse): CustomServiceResponse = CustomServiceResponse(
            docker = javaType.docker().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.DockerResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            endpoints = javaType.endpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.EndpointResponse.Companion.toKotlin(args0)
                })
            }),
            environmentVariables = javaType.environmentVariables().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.machinelearningservices.kotlin.outputs.EnvironmentVariableResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            image = javaType.image().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ImageResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            volumes = javaType.volumes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.VolumeDefinitionResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
