@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A DataLakeAnalytics compute.
 * @property computeLocation Location for the underlying compute
 * @property computeType The type of compute
 * Expected value is 'DataLakeAnalytics'.
 * @property createdOn The time at which the compute was created.
 * @property description The description of the Machine Learning compute.
 * @property disableLocalAuth Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
 * @property isAttachedCompute Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
 * @property modifiedOn The time at which the compute was last modified.
 * @property properties
 * @property provisioningErrors Errors during provisioning
 * @property provisioningState The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
 * @property resourceId ARM resource id of the underlying compute
 */
public data class DataLakeAnalyticsResponse(
    public val computeLocation: String? = null,
    public val computeType: String,
    public val createdOn: String,
    public val description: String? = null,
    public val disableLocalAuth: Boolean? = null,
    public val isAttachedCompute: Boolean,
    public val modifiedOn: String,
    public val properties: DataLakeAnalyticsSchemaResponseProperties? = null,
    public val provisioningErrors: List<ErrorResponseResponse>,
    public val provisioningState: String,
    public val resourceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.DataLakeAnalyticsResponse): DataLakeAnalyticsResponse = DataLakeAnalyticsResponse(
            computeLocation = javaType.computeLocation().map({ args0 -> args0 }).orElse(null),
            computeType = javaType.computeType(),
            createdOn = javaType.createdOn(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            disableLocalAuth = javaType.disableLocalAuth().map({ args0 -> args0 }).orElse(null),
            isAttachedCompute = javaType.isAttachedCompute(),
            modifiedOn = javaType.modifiedOn(),
            properties = javaType.properties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.DataLakeAnalyticsSchemaResponseProperties.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningErrors = javaType.provisioningErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ErrorResponseResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
