@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of Databricks
 * @property databricksAccessToken Databricks access token
 * @property workspaceUrl Workspace Url
 */
public data class DatabricksPropertiesResponse(
    public val databricksAccessToken: String? = null,
    public val workspaceUrl: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.DatabricksPropertiesResponse): DatabricksPropertiesResponse = DatabricksPropertiesResponse(
            databricksAccessToken = javaType.databricksAccessToken().map({ args0 -> args0 }).orElse(null),
            workspaceUrl = javaType.workspaceUrl().map({ args0 -> args0 }).orElse(null),
        )
    }
}
