@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *  Datastore and reference to location of data such as relativePath, Sql Query and etc.
 * @property additionalProperties Additional Properties.
 * @property azureFilePath Azure path for Azure Blob or File
 * @property datastoreName Data store Name
 * @property httpUrl HTTP URL.
 * @property partitionFormat Specify the partition format of path. Defaults to None.
 * @property partitionFormatIgnoreError Whether or not to ignore unmatched path.
 * @property paths List of files expanded from a file GLOB specified
 * @property relativePath Relative path in the data store
 * @property sqlDataPath Sql Query/Table/Stored Procedure details.
 */
public data class DatasetResponseDataPath(
    public val additionalProperties: Map<String, Any>? = null,
    public val azureFilePath: String,
    public val datastoreName: String,
    public val httpUrl: String,
    public val partitionFormat: String,
    public val partitionFormatIgnoreError: Boolean,
    public val paths: List<String>,
    public val relativePath: String,
    public val sqlDataPath: DatasetResponseSqlDataPath? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.DatasetResponseDataPath): DatasetResponseDataPath = DatasetResponseDataPath(
            additionalProperties = javaType.additionalProperties().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            azureFilePath = javaType.azureFilePath(),
            datastoreName = javaType.datastoreName(),
            httpUrl = javaType.httpUrl(),
            partitionFormat = javaType.partitionFormat(),
            partitionFormatIgnoreError = javaType.partitionFormatIgnoreError(),
            paths = javaType.paths().map({ args0 -> args0 }),
            relativePath = javaType.relativePath(),
            sqlDataPath = javaType.sqlDataPath().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.DatasetResponseSqlDataPath.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
