@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Sql Query/Table/Stored Procedure details.
 * @property queryTimeout SQL query timeout. Unit in seconds.
 * @property sqlQuery SQL query
 * @property sqlStoredProcedureName SQL storedProcedure name
 * @property sqlTableName SQL table name
 */
public data class DatasetResponseSqlDataPath(
    public val queryTimeout: Double,
    public val sqlQuery: String,
    public val sqlStoredProcedureName: String,
    public val sqlTableName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.DatasetResponseSqlDataPath): DatasetResponseSqlDataPath = DatasetResponseSqlDataPath(
            queryTimeout = javaType.queryTimeout(),
            sqlQuery = javaType.sqlQuery(),
            sqlStoredProcedureName = javaType.sqlStoredProcedureName(),
            sqlTableName = javaType.sqlTableName(),
        )
    }
}
