@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Dataset state
 * @property deprecatedBy Reference to better Dataset or a Definition
 * @property etag eTag description
 * @property state Dataset state
 */
public data class DatasetStateResponse(
    public val deprecatedBy: DatasetStateResponseDeprecatedBy? = null,
    public val etag: String,
    public val state: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.DatasetStateResponse): DatasetStateResponse = DatasetStateResponse(
            deprecatedBy = javaType.deprecatedBy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.DatasetStateResponseDeprecatedBy.Companion.toKotlin(args0)
                })
            }).orElse(null),
            etag = javaType.etag(),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
        )
    }
}
