@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Machine Learning datastore object.
 * @property azureDataLakeSection
 * @property azureMySqlSection
 * @property azurePostgreSqlSection
 * @property azureSqlDatabaseSection
 * @property azureStorageSection
 * @property createdBy The User who created the datastore.
 * @property createdTime The date and time when the datastore was created.
 * @property dataStoreType The datastore type.
 * @property description Description of the datastore.
 * @property glusterFsSection Data specific to GlusterFS.
 * @property hasBeenValidated A read only property that denotes whether the service datastore has been validated with credentials.
 * @property linkedInfo Info about origin if it is linked.
 * @property modifiedBy The User who modified the datastore.
 * @property modifiedTime The date and time when the datastore was last modified.
 * @property name Name of the datastore.
 * @property tags Tags for this datastore.
 */
public data class DatastoreResponse(
    public val azureDataLakeSection: AzureDataLakeSectionResponse? = null,
    public val azureMySqlSection: AzureMySqlSectionResponse? = null,
    public val azurePostgreSqlSection: AzurePostgreSqlSectionResponse? = null,
    public val azureSqlDatabaseSection: AzureSqlDatabaseSectionResponse? = null,
    public val azureStorageSection: AzureStorageSectionResponse? = null,
    public val createdBy: UserInfoResponse,
    public val createdTime: String,
    public val dataStoreType: String? = null,
    public val description: String? = null,
    public val glusterFsSection: GlusterFsSectionResponse? = null,
    public val hasBeenValidated: Boolean? = null,
    public val linkedInfo: LinkedInfoResponse? = null,
    public val modifiedBy: UserInfoResponse,
    public val modifiedTime: String,
    public val name: String? = null,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.DatastoreResponse): DatastoreResponse = DatastoreResponse(
            azureDataLakeSection = javaType.azureDataLakeSection().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.AzureDataLakeSectionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            azureMySqlSection = javaType.azureMySqlSection().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.AzureMySqlSectionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            azurePostgreSqlSection = javaType.azurePostgreSqlSection().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.AzurePostgreSqlSectionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            azureSqlDatabaseSection = javaType.azureSqlDatabaseSection().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.AzureSqlDatabaseSectionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            azureStorageSection = javaType.azureStorageSection().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.AzureStorageSectionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            createdBy = javaType.createdBy().let({ args0 ->
                com.pulumi.azurenative.machinelearningservices.kotlin.outputs.UserInfoResponse.Companion.toKotlin(args0)
            }),
            createdTime = javaType.createdTime(),
            dataStoreType = javaType.dataStoreType().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            glusterFsSection = javaType.glusterFsSection().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GlusterFsSectionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hasBeenValidated = javaType.hasBeenValidated().map({ args0 -> args0 }).orElse(null),
            linkedInfo = javaType.linkedInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.LinkedInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            modifiedBy = javaType.modifiedBy().let({ args0 ->
                com.pulumi.azurenative.machinelearningservices.kotlin.outputs.UserInfoResponse.Companion.toKotlin(args0)
            }),
            modifiedTime = javaType.modifiedTime(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
