@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property instanceCount Optional number of instances or nodes used by the compute target.
 * @property instanceType Optional type of VM used as supported by the compute target.
 * @property properties Additional properties bag.
 */
public data class DeploymentResourceConfigurationResponse(
    public val instanceCount: Int? = null,
    public val instanceType: String? = null,
    public val properties: Map<String, Any>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.DeploymentResourceConfigurationResponse): DeploymentResourceConfigurationResponse = DeploymentResourceConfigurationResponse(
            instanceCount = javaType.instanceCount().map({ args0 -> args0 }).orElse(null),
            instanceType = javaType.instanceType().map({ args0 -> args0 }).orElse(null),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
