@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property identityClientId For future use - The client id of the identity which will be used to access key vault.
 * @property keyIdentifier Key vault uri to access the encryption key.
 * @property keyVaultArmId The ArmId of the keyVault where the customer owned encryption key is present.
 */
public data class EncryptionKeyVaultPropertiesResponse(
    public val identityClientId: String? = null,
    public val keyIdentifier: String,
    public val keyVaultArmId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.EncryptionKeyVaultPropertiesResponse): EncryptionKeyVaultPropertiesResponse = EncryptionKeyVaultPropertiesResponse(
            identityClientId = javaType.identityClientId().map({ args0 -> args0 }).orElse(null),
            keyIdentifier = javaType.keyIdentifier(),
            keyVaultArmId = javaType.keyVaultArmId(),
        )
    }
}
