@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Environment version details.
 * @property autoRebuild Defines if image needs to be rebuilt based on base image changes.
 * @property build Configuration settings for Docker build context.
 * @property condaFile Standard configuration file used by Conda that lets you install any kind of package, including Python, R, and C/C++ packages.
 * <see href="https://repo2docker.readthedocs.io/en/latest/config_files.html#environment-yml-install-a-conda-environment" />
 * @property description The asset description text.
 * @property environmentType Environment type is either user managed or curated by the Azure ML service
 * <see href="https://docs.microsoft.com/en-us/azure/machine-learning/resource-curated-environments" />
 * @property image Name of the image that will be used for the environment.
 * <seealso href="https://docs.microsoft.com/en-us/azure/machine-learning/how-to-deploy-custom-docker-image#use-a-custom-base-image" />
 * @property inferenceConfig Defines configuration specific to inference.
 * @property isAnonymous If the name version are system generated (anonymous registration).
 * @property isArchived Is the asset archived?
 * @property osType The OS type of the environment.
 * @property properties The asset property dictionary.
 * @property provisioningState Provisioning state for the environment version.
 * @property stage Stage in the environment lifecycle assigned to this environment
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 */
public data class EnvironmentVersionResponse(
    public val autoRebuild: String? = null,
    public val build: BuildContextResponse? = null,
    public val condaFile: String? = null,
    public val description: String? = null,
    public val environmentType: String,
    public val image: String? = null,
    public val inferenceConfig: InferenceContainerPropertiesResponse? = null,
    public val isAnonymous: Boolean? = null,
    public val isArchived: Boolean? = null,
    public val osType: String? = null,
    public val properties: Map<String, String>? = null,
    public val provisioningState: String,
    public val stage: String? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.EnvironmentVersionResponse): EnvironmentVersionResponse = EnvironmentVersionResponse(
            autoRebuild = javaType.autoRebuild().map({ args0 -> args0 }).orElse(null),
            build = javaType.build().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.BuildContextResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            condaFile = javaType.condaFile().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            environmentType = javaType.environmentType(),
            image = javaType.image().map({ args0 -> args0 }).orElse(null),
            inferenceConfig = javaType.inferenceConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.InferenceContainerPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            isAnonymous = javaType.isAnonymous().map({ args0 -> args0 }).orElse(null),
            isArchived = javaType.isArchived().map({ args0 -> args0 }).orElse(null),
            osType = javaType.osType().map({ args0 -> args0 }).orElse(null),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            provisioningState = javaType.provisioningState(),
            stage = javaType.stage().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
