@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Suppress

/**
 * Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).
 * @property error The error object.
 */
public data class ErrorResponseResponse(
    public val error: ErrorDetailResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ErrorResponseResponse): ErrorResponseResponse = ErrorResponseResponse(
            error = javaType.error().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ErrorDetailResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
