@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * The estimated price info for using a VM of a particular OS type, tier, etc.
 * @property osType Operating system type used by the VM.
 * @property retailPrice The price charged for using the VM.
 * @property vmTier The type of the VM.
 */
public data class EstimatedVMPriceResponse(
    public val osType: String,
    public val retailPrice: Double,
    public val vmTier: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.EstimatedVMPriceResponse): EstimatedVMPriceResponse = EstimatedVMPriceResponse(
            osType = javaType.osType(),
            retailPrice = javaType.retailPrice(),
            vmTier = javaType.vmTier(),
        )
    }
}
