@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The estimated price info for using a VM.
 * @property billingCurrency Three lettered code specifying the currency of the VM price. Example: USD
 * @property unitOfMeasure The unit of time measurement for the specified VM price. Example: OneHour
 * @property values The list of estimated prices for using a VM of a particular OS type, tier, etc.
 */
public data class EstimatedVMPricesResponse(
    public val billingCurrency: String,
    public val unitOfMeasure: String,
    public val values: List<EstimatedVMPriceResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.EstimatedVMPricesResponse): EstimatedVMPricesResponse = EstimatedVMPricesResponse(
            billingCurrency = javaType.billingCurrency(),
            unitOfMeasure = javaType.unitOfMeasure(),
            values = javaType.values().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.EstimatedVMPriceResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
