@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specifies the feature window
 * @property featureWindowEnd Specifies the feature window end time
 * @property featureWindowStart Specifies the feature window start time
 */
public data class FeatureWindowResponse(
    public val featureWindowEnd: String? = null,
    public val featureWindowStart: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.FeatureWindowResponse): FeatureWindowResponse = FeatureWindowResponse(
            featureWindowEnd = javaType.featureWindowEnd().map({ args0 -> args0 }).orElse(null),
            featureWindowStart = javaType.featureWindowStart().map({ args0 -> args0 }).orElse(null),
        )
    }
}
