@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Dto object representing feature set version
 * @property autoDeleteSetting Specifies the lifecycle setting of managed data asset.
 * @property description The asset description text.
 * @property entities Specifies list of entities
 * @property isAnonymous If the name version are system generated (anonymous registration). For types where Stage is defined, when Stage is provided it will be used to populate IsAnonymous
 * @property isArchived Is the asset archived? For types where Stage is defined, when Stage is provided it will be used to populate IsArchived
 * @property materializationSettings Specifies the materialization settings
 * @property properties The asset property dictionary.
 * @property provisioningState Provisioning state for the featureset version container.
 * @property specification Specifies the feature spec details
 * @property stage Specifies the asset stage
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 */
public data class FeaturesetVersionResponse(
    public val autoDeleteSetting: AutoDeleteSettingResponse? = null,
    public val description: String? = null,
    public val entities: List<String>? = null,
    public val isAnonymous: Boolean? = null,
    public val isArchived: Boolean? = null,
    public val materializationSettings: MaterializationSettingsResponse? = null,
    public val properties: Map<String, String>? = null,
    public val provisioningState: String,
    public val specification: FeaturesetSpecificationResponse? = null,
    public val stage: String? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.FeaturesetVersionResponse): FeaturesetVersionResponse = FeaturesetVersionResponse(
            autoDeleteSetting = javaType.autoDeleteSetting().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.AutoDeleteSettingResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            entities = javaType.entities().map({ args0 -> args0 }),
            isAnonymous = javaType.isAnonymous().map({ args0 -> args0 }).orElse(null),
            isArchived = javaType.isArchived().map({ args0 -> args0 }).orElse(null),
            materializationSettings = javaType.materializationSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.MaterializationSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            provisioningState = javaType.provisioningState(),
            specification = javaType.specification().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.FeaturesetSpecificationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            stage = javaType.stage().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
