@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Dto object representing feature entity version
 * @property autoDeleteSetting Specifies the lifecycle setting of managed data asset.
 * @property description The asset description text.
 * @property indexColumns Specifies index columns
 * @property isAnonymous If the name version are system generated (anonymous registration). For types where Stage is defined, when Stage is provided it will be used to populate IsAnonymous
 * @property isArchived Is the asset archived? For types where Stage is defined, when Stage is provided it will be used to populate IsArchived
 * @property properties The asset property dictionary.
 * @property provisioningState Provisioning state for the featurestore entity version.
 * @property stage Specifies the asset stage
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 */
public data class FeaturestoreEntityVersionResponse(
    public val autoDeleteSetting: AutoDeleteSettingResponse? = null,
    public val description: String? = null,
    public val indexColumns: List<IndexColumnResponse>? = null,
    public val isAnonymous: Boolean? = null,
    public val isArchived: Boolean? = null,
    public val properties: Map<String, String>? = null,
    public val provisioningState: String,
    public val stage: String? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.FeaturestoreEntityVersionResponse): FeaturestoreEntityVersionResponse = FeaturestoreEntityVersionResponse(
            autoDeleteSetting = javaType.autoDeleteSetting().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.AutoDeleteSettingResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            indexColumns = javaType.indexColumns().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.IndexColumnResponse.Companion.toKotlin(args0)
                })
            }),
            isAnonymous = javaType.isAnonymous().map({ args0 -> args0 }).orElse(null),
            isArchived = javaType.isArchived().map({ args0 -> args0 }).orElse(null),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            provisioningState = javaType.provisioningState(),
            stage = javaType.stage().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
