@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Forecasting specific parameters.
 * @property countryOrRegionForHolidays Country or region for holidays for forecasting tasks.
 * These should be ISO 3166 two-letter country/region codes, for example 'US' or 'GB'.
 * @property cvStepSize Number of periods between the origin time of one CV fold and the next fold. For
 * example, if `CVStepSize` = 3 for daily data, the origin time for each fold will be
 * three days apart.
 * @property featureLags Flag for generating lags for the numeric features with 'auto' or null.
 * @property forecastHorizon The desired maximum forecast horizon in units of time-series frequency.
 * @property frequency When forecasting, this parameter represents the period with which the forecast is desired, for example daily, weekly, yearly, etc. The forecast frequency is dataset frequency by default.
 * @property seasonality Set time series seasonality as an integer multiple of the series frequency.
 * If seasonality is set to 'auto', it will be inferred.
 * @property shortSeriesHandlingConfig The parameter defining how if AutoML should handle short time series.
 * @property targetAggregateFunction The function to be used to aggregate the time series target column to conform to a user specified frequency.
 * If the TargetAggregateFunction is set i.e. not 'None', but the freq parameter is not set, the error is raised. The possible target aggregation functions are: "sum", "max", "min" and "mean".
 * @property targetLags The number of past periods to lag from the target column.
 * @property targetRollingWindowSize The number of past periods used to create a rolling window average of the target column.
 * @property timeColumnName The name of the time column. This parameter is required when forecasting to specify the datetime column in the input data used for building the time series and inferring its frequency.
 * @property timeSeriesIdColumnNames The names of columns used to group a timeseries. It can be used to create multiple series.
 * If grain is not defined, the data set is assumed to be one time-series. This parameter is used with task type forecasting.
 * @property useStl Configure STL Decomposition of the time-series target column.
 */
public data class ForecastingSettingsResponse(
    public val countryOrRegionForHolidays: String? = null,
    public val cvStepSize: Int? = null,
    public val featureLags: String? = null,
    public val forecastHorizon: Either<AutoForecastHorizonResponse, CustomForecastHorizonResponse>? =
        null,
    public val frequency: String? = null,
    public val seasonality: Either<AutoSeasonalityResponse, CustomSeasonalityResponse>? = null,
    public val shortSeriesHandlingConfig: String? = null,
    public val targetAggregateFunction: String? = null,
    public val targetLags: Either<AutoTargetLagsResponse, CustomTargetLagsResponse>? = null,
    public val targetRollingWindowSize: Either<AutoTargetRollingWindowSizeResponse, CustomTargetRollingWindowSizeResponse>? = null,
    public val timeColumnName: String? = null,
    public val timeSeriesIdColumnNames: List<String>? = null,
    public val useStl: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ForecastingSettingsResponse): ForecastingSettingsResponse = ForecastingSettingsResponse(
            countryOrRegionForHolidays = javaType.countryOrRegionForHolidays().map({ args0 ->
                args0
            }).orElse(null),
            cvStepSize = javaType.cvStepSize().map({ args0 -> args0 }).orElse(null),
            featureLags = javaType.featureLags().map({ args0 -> args0 }).orElse(null),
            forecastHorizon = javaType.forecastHorizon().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.machinelearningservices.kotlin.outputs.AutoForecastHorizonResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.machinelearningservices.kotlin.outputs.CustomForecastHorizonResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            frequency = javaType.frequency().map({ args0 -> args0 }).orElse(null),
            seasonality = javaType.seasonality().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.machinelearningservices.kotlin.outputs.AutoSeasonalityResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.machinelearningservices.kotlin.outputs.CustomSeasonalityResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            shortSeriesHandlingConfig = javaType.shortSeriesHandlingConfig().map({ args0 ->
                args0
            }).orElse(null),
            targetAggregateFunction = javaType.targetAggregateFunction().map({ args0 -> args0 }).orElse(null),
            targetLags = javaType.targetLags().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.machinelearningservices.kotlin.outputs.AutoTargetLagsResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.machinelearningservices.kotlin.outputs.CustomTargetLagsResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            targetRollingWindowSize = javaType.targetRollingWindowSize().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.machinelearningservices.kotlin.outputs.AutoTargetRollingWindowSizeResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.machinelearningservices.kotlin.outputs.CustomTargetRollingWindowSizeResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            timeColumnName = javaType.timeColumnName().map({ args0 -> args0 }).orElse(null),
            timeSeriesIdColumnNames = javaType.timeSeriesIdColumnNames().map({ args0 -> args0 }),
            useStl = javaType.useStl().map({ args0 -> args0 }).orElse(null),
        )
    }
}
