@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * FQDN Outbound Rule for the managed network of a machine learning workspace.
 * @property category Category of a managed network Outbound Rule of a machine learning workspace.
 * @property destination
 * @property status Status of a managed network Outbound Rule of a machine learning workspace.
 * @property type Type of a managed network Outbound Rule of a machine learning workspace.
 * Expected value is 'FQDN'.
 */
public data class FqdnOutboundRuleResponse(
    public val category: String? = null,
    public val destination: String? = null,
    public val status: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.FqdnOutboundRuleResponse): FqdnOutboundRuleResponse = FqdnOutboundRuleResponse(
            category = javaType.category().map({ args0 -> args0 }).orElse(null),
            destination = javaType.destination().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
