@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Machine Learning compute object wrapped into ARM resource envelope.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity The identity of the resource.
 * @property location Specifies the location of the resource.
 * @property name The name of the resource
 * @property properties Compute properties
 * @property sku The sku of the workspace.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Contains resource tags defined as key/value pairs.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetComputeResult(
    public val id: String,
    public val identity: ManagedServiceIdentityResponse? = null,
    public val location: String? = null,
    public val name: String,
    public val properties: Any,
    public val sku: SkuResponse? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.GetComputeResult): GetComputeResult = GetComputeResult(
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties(),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
