@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property actualCapacityInfo Gets or sets the actual capacity info for the group.
 * @property bonusExtraCapacity Gets or sets capacity used from the pool's reserved capacity.
 * @property endpointCount Gets or sets the actual number of endpoints in the group.
 * @property requestedCapacity Gets or sets the request number of instances for the group.
 */
public data class GetInferenceGroupStatusResult(
    public val actualCapacityInfo: ActualCapacityInfoResponse? = null,
    public val bonusExtraCapacity: Int? = null,
    public val endpointCount: Int? = null,
    public val requestedCapacity: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.GetInferenceGroupStatusResult): GetInferenceGroupStatusResult = GetInferenceGroupStatusResult(
            actualCapacityInfo = javaType.actualCapacityInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ActualCapacityInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            bonusExtraCapacity = javaType.bonusExtraCapacity().map({ args0 -> args0 }).orElse(null),
            endpointCount = javaType.endpointCount().map({ args0 -> args0 }).orElse(null),
            requestedCapacity = javaType.requestedCapacity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
