@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property actualCapacity Gets or sets the actual number of instances in the pool.
 * @property groupCount Gets or sets the actual number of groups in the pool.
 * @property requestedCapacity Gets or sets the requested number of instances for the pool.
 * @property reservedCapacity Gets or sets the number of instances in the pool reserved by the system.
 */
public data class GetInferencePoolStatusResult(
    public val actualCapacity: Int? = null,
    public val groupCount: Int? = null,
    public val requestedCapacity: Int? = null,
    public val reservedCapacity: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.GetInferencePoolStatusResult): GetInferencePoolStatusResult = GetInferencePoolStatusResult(
            actualCapacity = javaType.actualCapacity().map({ args0 -> args0 }).orElse(null),
            groupCount = javaType.groupCount().map({ args0 -> args0 }).orElse(null),
            requestedCapacity = javaType.requestedCapacity().map({ args0 -> args0 }).orElse(null),
            reservedCapacity = javaType.reservedCapacity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
