@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity Managed service identity (system assigned and/or user assigned identities)
 * @property kind Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property onlineDeploymentProperties [Required] Additional attributes of the entity.
 * @property sku Sku details required for ARM contract for Autoscaling.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetOnlineDeploymentResult(
    public val id: String,
    public val identity: ManagedServiceIdentityResponse? = null,
    public val kind: String? = null,
    public val location: String,
    public val name: String,
    public val onlineDeploymentProperties: Either<KubernetesOnlineDeploymentResponse, ManagedOnlineDeploymentResponse>,
    public val sku: SkuResponse? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.GetOnlineDeploymentResult): GetOnlineDeploymentResult = GetOnlineDeploymentResult(
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            onlineDeploymentProperties = javaType.onlineDeploymentProperties().transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.machinelearningservices.kotlin.outputs.KubernetesOnlineDeploymentResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ManagedOnlineDeploymentResponse.Companion.toKotlin(args0)
                    })
                },
            ),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
