@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Service Token
 * @property accessToken Access token for endpoint authentication.
 * @property expiryTimeUtc Access token expiry time (UTC).
 * @property refreshAfterTimeUtc Refresh access token after time (UTC).
 * @property tokenType Access token type.
 */
public data class GetOnlineEndpointTokenResult(
    public val accessToken: String? = null,
    public val expiryTimeUtc: Double? = null,
    public val refreshAfterTimeUtc: Double? = null,
    public val tokenType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.GetOnlineEndpointTokenResult): GetOnlineEndpointTokenResult = GetOnlineEndpointTokenResult(
            accessToken = javaType.accessToken().map({ args0 -> args0 }).orElse(null),
            expiryTimeUtc = javaType.expiryTimeUtc().map({ args0 -> args0 }).orElse(null),
            refreshAfterTimeUtc = javaType.refreshAfterTimeUtc().map({ args0 -> args0 }).orElse(null),
            tokenType = javaType.tokenType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
