@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Reference to an asset via its ARM resource ID.
 * @property assetId [Required] ARM resource ID of the asset.
 * @property referenceType Enum to determine which reference method to use for an asset.
 * Expected value is 'Id'.
 */
public data class IdAssetReferenceResponse(
    public val assetId: String,
    public val referenceType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.IdAssetReferenceResponse): IdAssetReferenceResponse = IdAssetReferenceResponse(
            assetId = javaType.assetId(),
            referenceType = javaType.referenceType(),
        )
    }
}
