@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Image Instance Segmentation. Instance segmentation is used to identify objects in an image at the pixel level,
 * drawing a polygon around each object in the image.
 * @property limitSettings [Required] Limit settings for the AutoML job.
 * @property logVerbosity Log verbosity for the job.
 * @property modelSettings Settings used for training the model.
 * @property primaryMetric Primary metric to optimize for this task.
 * @property searchSpace Search space for sampling different combinations of models and their hyperparameters.
 * @property sweepSettings Model sweeping and hyperparameter sweeping related settings.
 * @property targetColumnName Target column name: This is prediction values column.
 * Also known as label column name in context of classification tasks.
 * @property taskType AutoMLJob Task type.
 * Expected value is 'ImageInstanceSegmentation'.
 * @property trainingData [Required] Training data input.
 * @property validationData Validation data inputs.
 * @property validationDataSize The fraction of training dataset that needs to be set aside for validation purpose.
 * Values between (0.0 , 1.0)
 * Applied when validation dataset is not provided.
 */
public data class ImageInstanceSegmentationResponse(
    public val limitSettings: ImageLimitSettingsResponse,
    public val logVerbosity: String? = null,
    public val modelSettings: ImageModelSettingsObjectDetectionResponse? = null,
    public val primaryMetric: String? = null,
    public val searchSpace: List<ImageModelDistributionSettingsObjectDetectionResponse>? = null,
    public val sweepSettings: ImageSweepSettingsResponse? = null,
    public val targetColumnName: String? = null,
    public val taskType: String,
    public val trainingData: MLTableJobInputResponse,
    public val validationData: MLTableJobInputResponse? = null,
    public val validationDataSize: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ImageInstanceSegmentationResponse): ImageInstanceSegmentationResponse = ImageInstanceSegmentationResponse(
            limitSettings = javaType.limitSettings().let({ args0 ->
                com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ImageLimitSettingsResponse.Companion.toKotlin(args0)
            }),
            logVerbosity = javaType.logVerbosity().map({ args0 -> args0 }).orElse(null),
            modelSettings = javaType.modelSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ImageModelSettingsObjectDetectionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            primaryMetric = javaType.primaryMetric().map({ args0 -> args0 }).orElse(null),
            searchSpace = javaType.searchSpace().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ImageModelDistributionSettingsObjectDetectionResponse.Companion.toKotlin(args0)
                })
            }),
            sweepSettings = javaType.sweepSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ImageSweepSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            targetColumnName = javaType.targetColumnName().map({ args0 -> args0 }).orElse(null),
            taskType = javaType.taskType(),
            trainingData = javaType.trainingData().let({ args0 ->
                com.pulumi.azurenative.machinelearningservices.kotlin.outputs.MLTableJobInputResponse.Companion.toKotlin(args0)
            }),
            validationData = javaType.validationData().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.MLTableJobInputResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            validationDataSize = javaType.validationDataSize().map({ args0 -> args0 }).orElse(null),
        )
    }
}
