@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Settings used for training the model.
 * For more information on the available settings please visit the official documentation:
 * https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
 * @property advancedSettings Settings for advanced scenarios.
 * @property amsGradient Enable AMSGrad when optimizer is 'adam' or 'adamw'.
 * @property augmentations Settings for using Augmentations.
 * @property beta1 Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
 * @property beta2 Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
 * @property boxDetectionsPerImage Maximum number of detections per image, for all classes. Must be a positive integer.
 * Note: This settings is not supported for the 'yolov5' algorithm.
 * @property boxScoreThreshold During inference, only return proposals with a classification score greater than
 * BoxScoreThreshold. Must be a float in the range[0, 1].
 * @property checkpointFrequency Frequency to store model checkpoints. Must be a positive integer.
 * @property checkpointModel The pretrained checkpoint model for incremental training.
 * @property checkpointRunId The id of a previous run that has a pretrained checkpoint for incremental training.
 * @property distributed Whether to use distributed training.
 * @property earlyStopping Enable early stopping logic during training.
 * @property earlyStoppingDelay Minimum number of epochs or validation evaluations to wait before primary metric improvement
 * is tracked for early stopping. Must be a positive integer.
 * @property earlyStoppingPatience Minimum number of epochs or validation evaluations with no primary metric improvement before
 * the run is stopped. Must be a positive integer.
 * @property enableOnnxNormalization Enable normalization when exporting ONNX model.
 * @property evaluationFrequency Frequency to evaluate validation dataset to get metric scores. Must be a positive integer.
 * @property gradientAccumulationStep Gradient accumulation means running a configured number of "GradAccumulationStep" steps without
 * updating the model weights while accumulating the gradients of those steps, and then using
 * the accumulated gradients to compute the weight updates. Must be a positive integer.
 * @property imageSize Image size for train and validation. Must be a positive integer.
 * Note: The training run may get into CUDA OOM if the size is too big.
 * Note: This settings is only supported for the 'yolov5' algorithm.
 * @property layersToFreeze Number of layers to freeze for the model. Must be a positive integer.
 * For instance, passing 2 as value for 'seresnext' means
 * freezing layer0 and layer1. For a full list of models supported and details on layer freeze, please
 * see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
 * @property learningRate Initial learning rate. Must be a float in the range [0, 1].
 * @property learningRateScheduler Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
 * @property maxSize Maximum size of the image to be rescaled before feeding it to the backbone.
 * Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
 * Note: This settings is not supported for the 'yolov5' algorithm.
 * @property minSize Minimum size of the image to be rescaled before feeding it to the backbone.
 * Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
 * Note: This settings is not supported for the 'yolov5' algorithm.
 * @property modelName Name of the model to use for training.
 * For more information on the available models please visit the official documentation:
 * https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
 * @property modelSize Model size. Must be 'small', 'medium', 'large', or 'xlarge'.
 * Note: training run may get into CUDA OOM if the model size is too big.
 * Note: This settings is only supported for the 'yolov5' algorithm.
 * @property momentum Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
 * @property multiScale Enable multi-scale image by varying image size by +/- 50%.
 * Note: training run may get into CUDA OOM if no sufficient GPU memory.
 * Note: This settings is only supported for the 'yolov5' algorithm.
 * @property nesterov Enable nesterov when optimizer is 'sgd'.
 * @property nmsIouThreshold IOU threshold used during inference in NMS post processing. Must be a float in the range [0, 1].
 * @property numberOfEpochs Number of training epochs. Must be a positive integer.
 * @property numberOfWorkers Number of data loader workers. Must be a non-negative integer.
 * @property optimizer Type of optimizer.
 * @property randomSeed Random seed to be used when using deterministic training.
 * @property stepLRGamma Value of gamma when learning rate scheduler is 'step'. Must be a float in the range [0, 1].
 * @property stepLRStepSize Value of step size when learning rate scheduler is 'step'. Must be a positive integer.
 * @property tileGridSize The grid size to use for tiling each image. Note: TileGridSize must not be
 * None to enable small object detection logic. A string containing two integers in mxn format.
 * Note: This settings is not supported for the 'yolov5' algorithm.
 * @property tileOverlapRatio Overlap ratio between adjacent tiles in each dimension. Must be float in the range [0, 1).
 * Note: This settings is not supported for the 'yolov5' algorithm.
 * @property tilePredictionsNmsThreshold The IOU threshold to use to perform NMS while merging predictions from tiles and image.
 * Used in validation/ inference. Must be float in the range [0, 1].
 * Note: This settings is not supported for the 'yolov5' algorithm.
 * @property trainingBatchSize Training batch size. Must be a positive integer.
 * @property validationBatchSize Validation batch size. Must be a positive integer.
 * @property validationIouThreshold IOU threshold to use when computing validation metric. Must be float in the range [0, 1].
 * @property validationMetricType Metric computation method to use for validation metrics.
 * @property warmupCosineLRCycles Value of cosine cycle when learning rate scheduler is 'warmup_cosine'. Must be a float in the range [0, 1].
 * @property warmupCosineLRWarmupEpochs Value of warmup epochs when learning rate scheduler is 'warmup_cosine'. Must be a positive integer.
 * @property weightDecay Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be a float in the range[0, 1].
 */
public data class ImageModelSettingsObjectDetectionResponse(
    public val advancedSettings: String? = null,
    public val amsGradient: Boolean? = null,
    public val augmentations: String? = null,
    public val beta1: Double? = null,
    public val beta2: Double? = null,
    public val boxDetectionsPerImage: Int? = null,
    public val boxScoreThreshold: Double? = null,
    public val checkpointFrequency: Int? = null,
    public val checkpointModel: MLFlowModelJobInputResponse? = null,
    public val checkpointRunId: String? = null,
    public val distributed: Boolean? = null,
    public val earlyStopping: Boolean? = null,
    public val earlyStoppingDelay: Int? = null,
    public val earlyStoppingPatience: Int? = null,
    public val enableOnnxNormalization: Boolean? = null,
    public val evaluationFrequency: Int? = null,
    public val gradientAccumulationStep: Int? = null,
    public val imageSize: Int? = null,
    public val layersToFreeze: Int? = null,
    public val learningRate: Double? = null,
    public val learningRateScheduler: String? = null,
    public val maxSize: Int? = null,
    public val minSize: Int? = null,
    public val modelName: String? = null,
    public val modelSize: String? = null,
    public val momentum: Double? = null,
    public val multiScale: Boolean? = null,
    public val nesterov: Boolean? = null,
    public val nmsIouThreshold: Double? = null,
    public val numberOfEpochs: Int? = null,
    public val numberOfWorkers: Int? = null,
    public val optimizer: String? = null,
    public val randomSeed: Int? = null,
    public val stepLRGamma: Double? = null,
    public val stepLRStepSize: Int? = null,
    public val tileGridSize: String? = null,
    public val tileOverlapRatio: Double? = null,
    public val tilePredictionsNmsThreshold: Double? = null,
    public val trainingBatchSize: Int? = null,
    public val validationBatchSize: Int? = null,
    public val validationIouThreshold: Double? = null,
    public val validationMetricType: String? = null,
    public val warmupCosineLRCycles: Double? = null,
    public val warmupCosineLRWarmupEpochs: Int? = null,
    public val weightDecay: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ImageModelSettingsObjectDetectionResponse): ImageModelSettingsObjectDetectionResponse = ImageModelSettingsObjectDetectionResponse(
            advancedSettings = javaType.advancedSettings().map({ args0 -> args0 }).orElse(null),
            amsGradient = javaType.amsGradient().map({ args0 -> args0 }).orElse(null),
            augmentations = javaType.augmentations().map({ args0 -> args0 }).orElse(null),
            beta1 = javaType.beta1().map({ args0 -> args0 }).orElse(null),
            beta2 = javaType.beta2().map({ args0 -> args0 }).orElse(null),
            boxDetectionsPerImage = javaType.boxDetectionsPerImage().map({ args0 -> args0 }).orElse(null),
            boxScoreThreshold = javaType.boxScoreThreshold().map({ args0 -> args0 }).orElse(null),
            checkpointFrequency = javaType.checkpointFrequency().map({ args0 -> args0 }).orElse(null),
            checkpointModel = javaType.checkpointModel().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.MLFlowModelJobInputResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            checkpointRunId = javaType.checkpointRunId().map({ args0 -> args0 }).orElse(null),
            distributed = javaType.distributed().map({ args0 -> args0 }).orElse(null),
            earlyStopping = javaType.earlyStopping().map({ args0 -> args0 }).orElse(null),
            earlyStoppingDelay = javaType.earlyStoppingDelay().map({ args0 -> args0 }).orElse(null),
            earlyStoppingPatience = javaType.earlyStoppingPatience().map({ args0 -> args0 }).orElse(null),
            enableOnnxNormalization = javaType.enableOnnxNormalization().map({ args0 -> args0 }).orElse(null),
            evaluationFrequency = javaType.evaluationFrequency().map({ args0 -> args0 }).orElse(null),
            gradientAccumulationStep = javaType.gradientAccumulationStep().map({ args0 -> args0 }).orElse(null),
            imageSize = javaType.imageSize().map({ args0 -> args0 }).orElse(null),
            layersToFreeze = javaType.layersToFreeze().map({ args0 -> args0 }).orElse(null),
            learningRate = javaType.learningRate().map({ args0 -> args0 }).orElse(null),
            learningRateScheduler = javaType.learningRateScheduler().map({ args0 -> args0 }).orElse(null),
            maxSize = javaType.maxSize().map({ args0 -> args0 }).orElse(null),
            minSize = javaType.minSize().map({ args0 -> args0 }).orElse(null),
            modelName = javaType.modelName().map({ args0 -> args0 }).orElse(null),
            modelSize = javaType.modelSize().map({ args0 -> args0 }).orElse(null),
            momentum = javaType.momentum().map({ args0 -> args0 }).orElse(null),
            multiScale = javaType.multiScale().map({ args0 -> args0 }).orElse(null),
            nesterov = javaType.nesterov().map({ args0 -> args0 }).orElse(null),
            nmsIouThreshold = javaType.nmsIouThreshold().map({ args0 -> args0 }).orElse(null),
            numberOfEpochs = javaType.numberOfEpochs().map({ args0 -> args0 }).orElse(null),
            numberOfWorkers = javaType.numberOfWorkers().map({ args0 -> args0 }).orElse(null),
            optimizer = javaType.optimizer().map({ args0 -> args0 }).orElse(null),
            randomSeed = javaType.randomSeed().map({ args0 -> args0 }).orElse(null),
            stepLRGamma = javaType.stepLRGamma().map({ args0 -> args0 }).orElse(null),
            stepLRStepSize = javaType.stepLRStepSize().map({ args0 -> args0 }).orElse(null),
            tileGridSize = javaType.tileGridSize().map({ args0 -> args0 }).orElse(null),
            tileOverlapRatio = javaType.tileOverlapRatio().map({ args0 -> args0 }).orElse(null),
            tilePredictionsNmsThreshold = javaType.tilePredictionsNmsThreshold().map({ args0 ->
                args0
            }).orElse(null),
            trainingBatchSize = javaType.trainingBatchSize().map({ args0 -> args0 }).orElse(null),
            validationBatchSize = javaType.validationBatchSize().map({ args0 -> args0 }).orElse(null),
            validationIouThreshold = javaType.validationIouThreshold().map({ args0 -> args0 }).orElse(null),
            validationMetricType = javaType.validationMetricType().map({ args0 -> args0 }).orElse(null),
            warmupCosineLRCycles = javaType.warmupCosineLRCycles().map({ args0 -> args0 }).orElse(null),
            warmupCosineLRWarmupEpochs = javaType.warmupCosineLRWarmupEpochs().map({ args0 ->
                args0
            }).orElse(null),
            weightDecay = javaType.weightDecay().map({ args0 -> args0 }).orElse(null),
        )
    }
}
