@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the Image Specifications
 * @property reference Image reference
 * @property type Type of the image. Possible values are: docker - For docker images. azureml - For AzureML images
 */
public data class ImageResponse(
    public val reference: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ImageResponse): ImageResponse = ImageResponse(
            reference = javaType.reference().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
