@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property livenessRoute The route to check the liveness of the inference server container.
 * @property readinessRoute The route to check the readiness of the inference server container.
 * @property scoringRoute The port to send the scoring requests to, within the inference server container.
 */
public data class InferenceContainerPropertiesResponse(
    public val livenessRoute: RouteResponse? = null,
    public val readinessRoute: RouteResponse? = null,
    public val scoringRoute: RouteResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.InferenceContainerPropertiesResponse): InferenceContainerPropertiesResponse = InferenceContainerPropertiesResponse(
            livenessRoute = javaType.livenessRoute().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.RouteResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            readinessRoute = javaType.readinessRoute().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.RouteResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            scoringRoute = javaType.scoringRoute().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.RouteResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
