@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * InferenceEndpoint configuration
 * @property authMode [Required] Authentication mode for the endpoint.
 * @property description Description of the resource.
 * @property endpointUri Endpoint URI for the inference endpoint.
 * @property groupId [Required] Group within the same pool with which this endpoint needs to be associated with.
 * @property properties Property dictionary. Properties can be added, but not removed or altered.
 * @property provisioningState Provisioning state for the endpoint.
 */
public data class InferenceEndpointResponse(
    public val authMode: String,
    public val description: String? = null,
    public val endpointUri: String,
    public val groupId: String,
    public val properties: Map<String, String>? = null,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.InferenceEndpointResponse): InferenceEndpointResponse = InferenceEndpointResponse(
            authMode = javaType.authMode(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            endpointUri = javaType.endpointUri(),
            groupId = javaType.groupId(),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            provisioningState = javaType.provisioningState(),
        )
    }
}
