@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Inference group configuration
 * @property bonusExtraCapacity Capacity to be used from the pool's reserved capacity.
 * optional
 * @property description Description of the resource.
 * @property metadata Metadata for the inference group.
 * @property priority Priority of the group within the N:Microsoft.MachineLearning.ManagementFrontEnd.Contracts.V20230801Preview.Pools.InferencePools.
 * @property properties Property dictionary. Properties can be added, but not removed or altered.
 * @property provisioningState Provisioning state for the inference group.
 */
public data class InferenceGroupResponse(
    public val bonusExtraCapacity: Int? = null,
    public val description: String? = null,
    public val metadata: String? = null,
    public val priority: Int? = null,
    public val properties: Map<String, String>? = null,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.InferenceGroupResponse): InferenceGroupResponse = InferenceGroupResponse(
            bonusExtraCapacity = javaType.bonusExtraCapacity().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            metadata = javaType.metadata().map({ args0 -> args0 }).orElse(null),
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            provisioningState = javaType.provisioningState(),
        )
    }
}
