@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Instance type schema.
 * @property nodeSelector Node Selector
 * @property resources Resource requests/limits for this instance type
 */
public data class InstanceTypeSchemaResponse(
    public val nodeSelector: Map<String, String>? = null,
    public val resources: InstanceTypeSchemaResponseResources? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.InstanceTypeSchemaResponse): InstanceTypeSchemaResponse = InstanceTypeSchemaResponse(
            nodeSelector = javaType.nodeSelector().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            resources = javaType.resources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.InstanceTypeSchemaResponseResources.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
