@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Resource requests/limits for this instance type
 * @property limits Resource limits for this instance type
 * @property requests Resource requests for this instance type
 */
public data class InstanceTypeSchemaResponseResources(
    public val limits: Map<String, String>? = null,
    public val requests: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.InstanceTypeSchemaResponseResources): InstanceTypeSchemaResponseResources = InstanceTypeSchemaResponseResources(
            limits = javaType.limits().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            requests = javaType.requests().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
