@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property actionType
 * Expected value is 'CreateJob'.
 * @property jobBaseProperties [Required] Defines Schedule action definition details.
 */
public data class JobScheduleActionResponse(
    public val actionType: String,
    public val jobBaseProperties: Any,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.JobScheduleActionResponse): JobScheduleActionResponse = JobScheduleActionResponse(
            actionType = javaType.actionType(),
            jobBaseProperties = javaType.jobBaseProperties(),
        )
    }
}
