@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Job endpoint definition
 * @property endpoint Url for endpoint.
 * @property errorMessage Any error in the service.
 * @property jobServiceType Endpoint type.
 * @property nodes Nodes that user would like to start the service on.
 * If Nodes is not set or set to null, the service will only be started on leader node.
 * @property port Port for endpoint.
 * @property properties Additional properties to set on the endpoint.
 * @property status Status of endpoint.
 */
public data class JobServiceResponse(
    public val endpoint: String? = null,
    public val errorMessage: String,
    public val jobServiceType: String? = null,
    public val nodes: AllNodesResponse? = null,
    public val port: Int? = null,
    public val properties: Map<String, String>? = null,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.JobServiceResponse): JobServiceResponse = JobServiceResponse(
            endpoint = javaType.endpoint().map({ args0 -> args0 }).orElse(null),
            errorMessage = javaType.errorMessage(),
            jobServiceType = javaType.jobServiceType().map({ args0 -> args0 }).orElse(null),
            nodes = javaType.nodes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.AllNodesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            status = javaType.status(),
        )
    }
}
