@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of a labeling job for image data
 * @property annotationType Annotation type of image labeling job.
 * @property mediaType Media type of data asset.
 * Expected value is 'Image'.
 */
public data class LabelingJobImagePropertiesResponse(
    public val annotationType: String? = null,
    public val mediaType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.LabelingJobImagePropertiesResponse): LabelingJobImagePropertiesResponse = LabelingJobImagePropertiesResponse(
            annotationType = javaType.annotationType().map({ args0 -> args0 }).orElse(null),
            mediaType = javaType.mediaType(),
        )
    }
}
