@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Info about origin if it is linked.
 * @property linkedId LinkedId id.
 * @property linkedResourceName Linked resource name.
 * @property origin Datastore origin
 */
public data class LinkedInfoResponse(
    public val linkedId: String? = null,
    public val linkedResourceName: String? = null,
    public val origin: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.LinkedInfoResponse): LinkedInfoResponse = LinkedInfoResponse(
            linkedId = javaType.linkedId().map({ args0 -> args0 }).orElse(null),
            linkedResourceName = javaType.linkedResourceName().map({ args0 -> args0 }).orElse(null),
            origin = javaType.origin().map({ args0 -> args0 }).orElse(null),
        )
    }
}
