@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * LinkedService specific properties.
 * @property createdTime The creation time of the linked service.
 * @property linkType Type of the link target.
 * @property linkedServiceResourceId ResourceId of the link target of the linked service.
 * @property modifiedTime The last modified time of the linked service.
 */
public data class LinkedServicePropsResponse(
    public val createdTime: String? = null,
    public val linkType: String? = null,
    public val linkedServiceResourceId: String,
    public val modifiedTime: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.LinkedServicePropsResponse): LinkedServicePropsResponse = LinkedServicePropsResponse(
            createdTime = javaType.createdTime().map({ args0 -> args0 }).orElse(null),
            linkType = javaType.linkType().map({ args0 -> args0 }).orElse(null),
            linkedServiceResourceId = javaType.linkedServiceResourceId(),
            modifiedTime = javaType.modifiedTime().map({ args0 -> args0 }).orElse(null),
        )
    }
}
